<?php

/**
 * Template Name: functions.php
 * Description: Theme features
 */

function fn_theme_scripts(){
	//includ file styles
	
	wp_enqueue_style('fontawesome', get_template_directory_uri().'/assets/css/fontawesome/fontawesome.css');
	wp_enqueue_style('bootstrap', get_template_directory_uri().'/assets/css/bootstrap.min.css');
	wp_enqueue_style('feather', get_template_directory_uri().'/assets/css/feather.css');
	wp_enqueue_style('select2', get_template_directory_uri().'/assets/css/select2.min.css');
	wp_enqueue_style('splide', get_template_directory_uri().'/assets/css/splide.min.css');
	wp_enqueue_style('main', get_template_directory_uri().'/assets/css/main.css');
	wp_enqueue_style('timepicker', get_template_directory_uri().'/assets/timepicker/jquery.datetimepicker.css');
	wp_enqueue_style('brown.css', get_template_directory_uri().'/assets/css/brown.css');

	wp_enqueue_style('main-style', get_stylesheet_uri());



}

add_action('wp_enqueue_scripts', 'fn_theme_scripts');

//theme js
function ti_custom_javascript() {
     
     // wp_enqueue_script('jquery', get_template_directory_uri().'/assets/js/vendor/jquery.min.js',array(),1,1,1);
     // wp_enqueue_script('jquery');
	wp_enqueue_script('popper', get_template_directory_uri().'/assets/js/vendor/popper-core.js',array(),1,1,1);
	wp_enqueue_script('popper');
	wp_enqueue_script('bootstrapjs', get_template_directory_uri().'/assets/js/vendor/bootstrap.min.js',array(),1,1,1);
	wp_enqueue_script('bootstrapjs');
	wp_enqueue_script('appearjs', get_template_directory_uri().'/assets/js/vendor/appear.js',array(),1,1,1);
	wp_enqueue_script('appearjs');
    wp_enqueue_script('countTojs', get_template_directory_uri().'/assets/js/vendor/countTo.js',array(),1,1,1);
    wp_enqueue_script('countTo');
	wp_enqueue_script('splidejs', get_template_directory_uri().'/assets/js/vendor/splide.min.js',array(),1,1,1);
	wp_enqueue_script('splidejs');
    wp_enqueue_script('select2js', get_template_directory_uri().'/assets/js/vendor/select2.min.js',array(),1,1,1);
    wp_enqueue_script('select2js');
    wp_enqueue_script('typedjs', get_template_directory_uri().'/assets/js/vendor/typed.min.js',array(),1,1,1);
    wp_enqueue_script('typedjs');
    wp_enqueue_script('tippyjs', get_template_directory_uri().'/assets/js/vendor/tippy.js',array(),1,1,1);
    wp_enqueue_script('tippyjs');
    wp_enqueue_script('mainjs', get_template_directory_uri().'/assets/js/main.js',array(),1,1,1);
    wp_enqueue_script('mainjs');
    wp_enqueue_script('pag', get_template_directory_uri().'/assets/js/pagination.min.js');
    wp_enqueue_script('pag');

    

   

    // wp_enqueue_script('timepickerdatejs', get_template_directory_uri().'/assets/timepicker/jquery.datetimepicker.js',array(),1,1,1);
    // wp_enqueue_script('timepickerdatejs');
    // wp_enqueue_script('timepickerjs', get_template_directory_uri().'/assets/timepicker/jquery.js',array(),1,1,1);
    // wp_enqueue_script('timepickerjs');


   
        

}
add_action('wp_enqueue_scripts', 'ti_custom_javascript');

//wordpress theme features

function theme_support(){
	add_theme_support('title-tag');
	add_theme_support('post-thumbnails');
	add_theme_support('html5', array('search-form'));
	add_theme_support('custom-logo');
	add_theme_support('widgets');


}

add_action('after_setup_theme', 'theme_support');

function nav_menu(){
	register_nav_menus(array(
		'primary-menu' => __('Primary Menu', 'text_domain'),
		'footer-menu' => __('Footer Menu', 'text_domain'),
		'terms-menu' => __('Terms Menu', 'text_domain'),
	    'footer-services' => __('Footer Services Menu', 'text_domain'),
	     'alabama-services' => __('Alabana Services Menu', 'text_domain'),
	     'alaska-services' => __('Alaska Services Menu', 'text_domain'),
	     'arizona-services' => __('Arizona Services Menu', 'text_domain'),
	     'arkansas-services' => __('Arkansas Services Menu', 'text_domain'),
	     'california-services' => __('California Services Menu', 'text_domain'),
	     'colorado-services' => __('Colorado Services Menu', 'text_domain'),
	     'connecticut-services' => __('Connecticut Services Menu', 'text_domain'),

		 ));
}
 
 add_action('init', 'nav_menu');



// function technig_the_content($content)
//   {
//     // Take the existing content and return a subset of characters it
//     return substr($content, 0, 200);
//   }

//   add_filter("the_content", "technig_the_content");

function add_links_atts($attr){

	$attr['class'] = 'nav-link';

	return $attr;

}

add_filter('nav_menu_link_attributes', 'add_links_atts');


function add_classes_on_li($classes, $item, $args) {
    if ( 'primary-menu' === $args->theme_location ) { //replace main-menu with your menu
    $classes[] = "nav-item"; 
    }
    return $classes;
}
add_filter('nav_menu_css_class','add_classes_on_li',1,3);


// function my_nav_menu_submenu_css_class($classes, $item, $args ) {
//     $classes[] = 'dropdown-item';
//     return $classes;
// }
// add_filter( 'nav_menu_submenu_css_class', 'add_classes_on_li',1,3 );



// function new_submenu_class($menu) {    
//     $menu = preg_replace('/ class="sub-menu"/','/ class="dropdown-item" /',$menu);        
//     return $menu;      
// }

//add_filter('nav_menu_submenu_css_class','new_submenu_class');
//


// function your_submenu_class($menu) {

// $menu = preg_replace('/ class="nav_item"/','/ class="sub-menu dropdown-item" /',$menu);  

// return $menu;  

// }

//add_filter('wp_nav_menu','your_submenu_class'); 

function prefix_wcount(){
    ob_start();
    the_content();
    $content = ob_get_clean();
    return sizeof(explode(" ", $content));
}



// add_action( 'init', 'session_start' );
// function start_session() {
// if(!session_id()) {
// session_start();
// }
// }


?>